*** COS 20218 11, last update 2023 03  
           
           
           
program define dq_report, rclass  
syntax, [sd(string) hd(string) ld(string) sdmd(string) rd(string) rdd(string) srdd(string) gd(string) gdth(string) gddq(string) targetfiles(string) metadatafile(string) interpretationtextfile(string) subgroupreference(string) lowercase(int 1)] 					///														  
	    [keyvars(string) minorvars(string) processvars(string) controlvars(string) observervars(string) devicevars(string) centervars(string) timevars(string) idvars(string)  casemissvars(string) casemisstype(string) casemisslogic(string)]							///  
		[reportname(string) segmentname(string) segmentselect(string) segmentexclude(string) varselect(string) reporttitle(string) reportsubtitle(string) reportformat(string) reporttemplate(string) replacereport(int 0)]												///			  
		[maxvarlabellength (int 40) view_interpretation(int 1) view_integrity(int 1) view_dqi(int 1) view_changelog(int 1) histkat (int 11) varlinebreak(int 1) sectionlinebreak(int 1) linenumberpagebreak(int 7) clustercolorpalettes(string) decimals(int 2)] 		///	  
		[warncolor(string) forcecalc(int 1) subgroup(string) missrecode(int 0) recodeminprop(real .95) jumpto0recode(int 0) nomod(int 0) nocompress outcheck(int 1) outsens(int 1) outintegrate(int 1) ] 																///  
		[itemmisslist(string) itemjumplist(string) binaryrecodelimit(int 8) metriclevels(int 25) minreportn(int 30) minclustersize_icc(int 10) minclustersize_lowess(int 40) minevent_lowess(int 2) problemvarreport(int 0) minvarnum(int 1) benchmark(int 0)]			///  
		[resultreport(int 0) rr_ordervar(string) structure(string)  ststrata(string) stcluster(string) breakreport(int 0)  indent(int 0) dataquieR]  
local indent=`indent'  
local adoname "dq_report"  
local text_i "di as text _n "  					  
* Local to force stop of program (1=yes, 0=no)  
local stop=0										  
local reportstop=0									  
return local reportstop=1							  
return local reportname="`reportname'"				  
local reportcount=0									  
	          
local vt_0 "all"  
local vt_1 "key"  
local vt_2 "minor"  
local vt_3 "process"  
local vt_4 "control"  
local vt_5 "time"  
local vt_6 "observer"  
local vt_7 "device"  
local vt_8 "center"  
local vt_9 "pipeline" 				  
local pipelinevarnumber=0			  
local vt_10 "casemiss"  
local vt_11 "const"  
local vt_12 "id" 				  
local vts_0 "al" 				  
local vts_1 "ky" 				  
local vts_2 "mi" 				  
local vts_3 "pr" 				  
local vts_4 "co" 				  
local vts_5 "ti" 				  
local vts_6 "ob" 				  
local vts_7 "de" 				  
local vts_8 "ce" 				  
local vts_9 "pl" 				  
local vts_10 "mi" 				  
local vts_11 "ct" 				  
local vts_12 "id" 				  
local strata "all"				  
local stringvars ""				  
local remove_time ""			  
if `resultreport'>0 {  
	dq_fil_res, srdd("`srdd'") reportname("`reportname'") segmentname("`segmentname'") targetfiles("`targetfiles'") ///  
		resultreport(`resultreport') breakreport(`breakreport') benchmark(`benchmark')  indent(`indent')  
	if `r(reportstop)'==1 {  
		local reportstop=1  
		di as error "The report will be stopped because of some error when reading the result file!"  
	}         
	if `reportstop'==0 {  
		local metadatafileexist=1														  
		local allclvars="`r(allclvars)'"  
		local clustervarnumber=wordcount("`allclvars'")									  
		foreach vartype in id key minor process control observer device center time  {  
			if "`r(`vartype'vars)'"~=""  local `vartype'vars "`r(`vartype'vars)'" 		  
			local `vartype'varnumber=wordcount("``vartype'vars'")						  
		}        
	}         
}          
if  `problemvarreport'>0 {	  
		         
	 * Change folder and name because search must not be on problem variable report  
	 local srddpass=subinstr("`srdd'","\problemreport\","\",.)  
	 local reportnamepass=subinstr("`reportname'","_issuereport","",.)							  
	`text_i' "Problem variable report requested - check for existence of resultfile: "  
	`text_i' "`srddpass'\Resultscalars_`reportnamepass'_`subgroupreference'_`reporttemplate'.dta"	_n  
	          
	dq_fil_exc, cdir("`srddpass'") cfile(Resultscalars_`reportnamepass'_`subgroupreference'_`reporttemplate'.dta) filetype(Result data)  indent(`indent')  
	if `r(reportstop)'>0  exit		  
	if `r(reportstop)'==0 {				  
	          
		qui ds dqi_varmax*				  
		local dqivar `r(varlist)'  
		local keyvars ""  
		         
		mata: nobs=st_nobs()  
		mata: st_numscalar("nobs",nobs)		  
		local nobs=nobs  
		         
		forvalues row=1/`nobs' {  
			if `dqivar'[`row']>=`problemvarreport' & modified[`row']==0 {  
				local addvar= var_name[`row']  
				if  variable_rolenumber[`row']~=4 & strpos("`keyvars'","`addvar'")==0 local keyvars "`keyvars' `addvar'"		  
			}       
		}        
		         
		if "`keyvars'" =="" {  
			`text_i' "No variable with the specified problem setting `problemvarreport' encountered."  
			return local reportstop=0	  
			$lineoutput paragraph  
			$lineoutput text ("$problemreportheader2")												, bold font($textfont, $header1, $textcolor)  
			$lineoutput paragraph  
			exit    
		}        
		         
		local forcecalc=0	  
		local minorvars ""  
		local processvars ""	  
		*local reportname		"`reportname'_problemreport"	  
		local idvars "`idvars'"  
		local reporttitle		"`reporttitle'_problemreport"	  
		local reportsubtitle	"$subheadertext_1 `problemvarreport'"	  
		         
	}         
	          
}          
if `resultreport'==0   {  
	if "`metadatafile'"~=""   {			  
	          
		*** Exclude loading of information from metadatafile dependent on infos from command syntax_analysissettings into scalars  
		local checkvarlist=strtrim("`keyvars' `minorvars' `processvars' `controlvars' `idvars'")						  
		         
		local studymetadatafields "var_name varlabel varshortlabel value_label data_type scalelevel limit_soft_low limit_soft_up limit_hard_low limit_hard_up missinglist jumplist refcat eventcat key_observer key_device key_datetime variablerole var_order"  
		         
		if "`observervars'"~="" local studymetadatafields = subinstr("`studymetadatafields'", "key_observer", 	"",1)  	  
		if "`devicevars'"~="" 	local studymetadatafields = subinstr("`studymetadatafields'", "key_device", 	"",1)  	  
		if "`centervars'"~="" 	local studymetadatafields = subinstr("`studymetadatafields'", "key_center", 	"",1) 	  
		if "`timevars'"~="" 	local studymetadatafields = subinstr("`studymetadatafields'", "key_datetime", 	"",1)  	  
		if "`controlvars'"~="" 	local studymetadatafields = subinstr("`studymetadatafields'", "key_controlvars","",1)  	  
		if "`keyvars'"~="" 		local studymetadatafields = subinstr("`studymetadatafields'", "variablerole",	"",1)  	  
		if `problemvarreport'>0 local studymetadatafields = subinstr("`studymetadatafields'", "variablerole",	"",1)  	  
		if "`targetfiles'"=="" 	local studymetadatafields = "`studymetadatafields' sourcefilename"  					  
		dq_fil_met, sd("`sdmd'") metadatafile("`metadatafile'") macroextensionname("_mdpt") infotype(0) 																	///  
				columnrequest("`studymetadatafields'") checkvarlist("`checkvarlist'") segmentname(`segmentname') segmentselect(`segmentselect') varselect(`varselect')  	///  
				keyvars("`keyvars'") minorvars("`minorvars'") processvars("`processvars'") observervars("`observervars'") devicevars("`devicevars'") 						///  
				centervars("`centervars'") timevars("`timevars'") controlvars("`controlvars'") idvars("`idvars'") 															///  
				minvarnum(`minvarnum') `dataquieR'  indent(`indent')   					  
				       
		if `r(reportstop)'==1 {  
			local reportstop=1  
		}        
		         
		if `r(reportstop)'==0 {  
			local metadatafileexist=1		  
			local metadatalines=`r(metadatalines)'  
			if "`targetfiles'"=="" {  
				if trim("`r(targetfiles)'")=="" {  
					di as error "No useful source file info retrieved from metadata file and no source data file has been specified with the target files option. Check command or metadata and restart!" _n  
					dq_out_add ,  tablename(integtable_metadata) row(integtablerows_metadata) columns(3) colcontent1("$Critical_1") colcontent2("`metadatafile'") colcontent3("$DQ_INT_critical_29")  indent(`indent')	  
					local reportstop=1  
				}      
				if trim("`r(targetfiles)'")~="" {  
					local targetfiles=trim("`r(targetfiles)'")								  
				}      
			}       
			        
			foreach vartype in idvars keyvars minorvars processvars controlvars {  
				if "`r(`vartype')'"~=""  local `vartype' "`r(`vartype')'" 			  
			}       
			        
		}        
				       
	}         
	if "`metadatafile'"==""   {  
		*** DQ_process_decision: DQ_INTcall_2, Indicator: Insufficient program call, Implementation form: No metadata file specified  
		dq_out_add ,  tablename(integtable_commandcall) row(integtablerows_commandcall) columns(3) colcontent1("$Note_1") colcontent2("$Meta_1") colcontent3($DQ_INTcall_warn_2)  indent(`indent') 	  
		local metadatafileexist=0		  
	}         
	          
		         
	dq_fil_std, sd("`sd'") rd("`rd'") reportname("`reportname'") problemvarreport(`problemvarreport') targetfiles("`targetfiles'") idvars("`idvars'") breakreport(`breakreport') lowercase(`lowercase')  indent(`indent')  
	if `r(reportstop)'==1 local reportstop=1  
}          
if `reportstop'==1 {  
	`text_i' "dq_report ended with error code after file read in section: `r(reportstop)'"  
	exit      
}          
if `resultreport'==0 {	  
	          
	mata: nvar=st_nvar()  
	mata: st_numscalar("nvar",nvar)		  
	scalar originaldataset_varnum=nvar  
	capture confirm variable id_unique  
	if _rc==0 scalar originaldataset_varnum=originaldataset_varnum-1  
	          
	tempvar C_onstant  
	qui gen `C_onstant'=1  
	lab var `C_onstant' "Constant"  
	local constvars "`C_onstant'"  
	local constvarnumber = 1  
	          
	qui count if `C_onstant' <.  
	scalar dataset_initalobsnum=r(N)  
	scalar dataset_obsnum=r(N)											  
	if `=dataset_obsnum'<`minreportn' {	  													  
		*** DQ_process_decision: 	DQ_INTP_4  
		dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) ///  
										colcontent1("$Critical_1") colcontent2($Dataset_1) colcontent3($DQ_INTP_4 `=dataset_obsnum'; $Settingdescriptor_4 `minreportn')  indent(`indent')  
		exit	    
	}         
}          
local subgroupname "all"  
local subgroup ""  
if `resultreport'==0 {	  
	global subgroupselectiontext1 ""																		  
	global subgroupselectiontext2 ""																		  
	if "`subgroup'"~=""  {		  
		         
		local subgroupname "`subgroup'"																		  
		local subgroup "if `subgroup'"																		  
		qui capture count `subgroup'  
		if _rc==0 {			  
			scalar dataset_obsnum=r(N)																		  
			if `=dataset_obsnum'==0 {																		  
				*** DQ_process_decision: 	DQ_INTP_3  
				dq_out_add ,  tablename(integtable_analysisconduct) row(integtablerows_analysisconduct) columns(3) colcontent1("$Critical_1") colcontent2("$Subgroup_1 $Logic_1 : `subgroup'") colcontent3($DQ_INTP_issue_3)  indent(`indent')  
				local reportstop=1					  
			}       
			else if `=dataset_obsnum'<`minreportn' {	  													  
				*** DQ_process_decision: 	DQ_INTP_4  
				dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) colcontent1("$Critical_1") colcontent2("$Subgroup_1 $Logic_1 : `subgroup'") colcontent3($DQ_INTP_issue_4 `=dataset_obsnum'; $Settingdescriptor_4 `minreportn')  indent(`indent')  
				local reportstop=1			  
			}       
			else {  
				keep `subgroup'																				  
				local deleten=`=dataset_initalobsnum'-`=dataset_obsnum'										  
				global subgroupselectiontext1 `"$Subgroupselect_1 `subgroup'."'  
				global subgroupselectiontext2 `"N $Sample_1 = `=dataset_initalobsnum'; N $Sample_2 = `=dataset_obsnum'; $Deleted_1: N = `deleten'"'  
				local subgroup ""																			  
				*if `changedatevar'==1 drop `timevars'  													  
			}       
		}        
		else {   
			di as error "Subgroup term not usable, no subgroup will be selected and dqrep will be terminated."  
			di as text "  "  
			*** DQ_process_decision: 	DQ_INT_10  
			dq_out_add ,  tablename(integtable_metadata) row(integtablerows_metadata) columns(3) colcontent1("$Critical_1") colcontent2("$Subgroup_1 $Logic_1 : `subgroup'") colcontent3($DQ_INT_issue_10)  indent(`indent')  
			local reportstop=1		  
		}        
	}         
}          
if `resultreport'==0 {																	  
	if "`itemmisslist'"~="" {  
		dq_hlp_nlc , numstring("`itemmisslist'") integer(1)  indent(`indent')  
		local itemmisslist "`r(numstring)'"  
	}         
	if "`itemjumplist'"~="" {  
		dq_hlp_nlc , numstring("`itemjumplist'") integer(1)  indent(`indent')  
		local itemjumplist "`r(numstring)'"  
	}         
	          
}          
if `resultreport'==0 {																	  
	          
	dq_out_mac, text(key_)  indent(`indent')					  
	foreach testscalar in `r(macroselectlist)' {										  
		if "`=`testscalar''" ~=""  {													  
			foreach vartype in observer device center time {  
				if strpos("`testscalar'","`vartype'" )>0 & strpos("``vartype'vars'", "`=`testscalar''")==0 {	  
					local `vartype'vars "``vartype'vars' `=`testscalar''"		  
					local `vartype'varnumber=wordcount("``vartype'vars'")		  
				}      
			}       
		}        
	}         
	if "`keyvars'"=="" & "`segmentselect'"=="nosegmentselect"  {  
		         
		dq_out_add ,  tablename(integtable_commandcall) row(integtablerows_commandcall) columns(3) colcontent1("$Action_1") colcontent2("$vt_1") colcontent3($varselect_action_1)  indent(`indent')  
		         
		if `metadatafileexist'==0 {  
			`text_i' "No keyoutcomes have been specified and no metadatafile has been specified. As default all study data variables will be considered."  
			foreach var of varlist _all{  
				local mergevars ""  
				capture ds _merge_*  
				if _rc==0 {  
					local mergevars "`r(varlist)'"  
				}      
				local addvar "`var'"  
				foreach excludevar in `C_onstant' `idvars' id_unique `mergevars' `minorvars' `controlvars' `processvars' `centervars' `devicevars' `observervars' `timevars' `casemissvars' {  
					if "`var'"=="`excludevar'" local addvar ""  
				}	     
				local keyvars "`keyvars' `addvar'"  
			}       
		}        
		         
		if `metadatafileexist'==1 {  
			`text_i' "No keyoutcomes have been specified and a metadatafile has been specified. As default all variables in the metadata list will be considered."  
			forvalues row=1/`metadatalines' {  
				local addvar "`=var_name_mdpt`row''"  
				foreach excludevar in `C_onstant' `idvars' id_unique `minorvars' `controlvars' `processvars' `centervars' `devicevars' `observervars' `timevars' `casemissvars' {  
					if "`var'"=="`excludevar'" local addvar ""  
				}	     
				local keyvars=trim("`keyvars' `addvar'")  
			}       
		}	       
	}	        
	local controlterm1  "`idvars' `casemissvars' `timevars' `observervars' `devicevars' `centervars' `controlvars' "  
	local controlterm2  "`idvars' `casemissvars' `timevars' `observervars' `devicevars' `centervars' `processvars' `controlvars' `keyvars'"  
	local controlterm3  "`idvars' `casemissvars' `timevars' `observervars' `devicevars' `centervars' `keyvars'"  
	local controlterm4  "`idvars' `casemissvars' `timevars' `observervars' `devicevars' `centervars' `processvars' `keyvars'"  
	local controlterm5  "`idvars' `casemissvars'"  
	local controlterm6  "`idvars' `casemissvars' `timevars'"  
	local controlterm7  "`idvars' `casemissvars' `timevars' `observervars'"  
	local controlterm8  "`idvars' `casemissvars' `timevars' `observervars' `devicevars'"  
	local controlterm10 "`idvars'"  
	foreach num of numlist 1 2 4 3 8 7 6 5 10 {  
	    local vt="`vt_`num''vars"  
		local nowarn ""  
		if "`segmentselect'"~="" & `num'==3 local nowarn "nowarn(1)"  
		dq_hlp_dds1 , cleanstring("``vt''") controlterm("`controlterm`num''") vartype(`num') `nowarn'  indent(`indent')  
		local `vt' = "`r(cleanstring)'"  
	}         
	          
}          
if `resultreport'==0 {																	  
	          
	foreach num of numlist 1 2 3 4 5 6 7 8 10 {  
	    local vt="`vt_`num''vars"  
		dq_int_var1 , varchecklist(``vt'') tablename(integtable_studydata) row(integtablerows_studydata) breakreport(`breakreport') vartype(`num')  indent(`indent')  
		local  `vt_`num''vars = "`r(varchecklist)'"  
		local  `vt_`num''varnumber = `r(varnumber)'  
		scalar `vt_`num''varnumber = `r(varnumber)'	  
	}         
}          
if `resultreport'==0 & am_allsum[1,1]>0  {  
	          
			        
	* This is necessary to correctly refer to all variables with result scalars  
	local n=0																	  
	foreach num of numlist 1 2 3 4 5 6 7 8 10 {  
	    local vt="`vt_`num''vars"  
		foreach var in ``vt''  {  
			local ++n  
			global `var' pt`n'													  
		} 	      
	}         
	local allvars="`keyvars' `minorvars' `processvars' `controlvars' `timevars' `observervars' `devicevars' `centervars' `casemissvars'"  
	dq_hlp_dds1, cleanstring("`allvars'") nowarn(1)   indent(`indent')  
	local allvars "`r(cleanstring)'"		  
	* the known information used is the stored variable key name in the "first column of the scalar  
	          
	local row=1  
	capture confirm scalar var_name_mdpt`row'										  
	while _rc==0 {																	  
		if "`=var_name_mdpt`row''"~="" {											  
			if "$`=var_name_mdpt`row''"~="" {										  
				if strpos("`allvars'", "`=var_name_mdpt`row''")>0 {					  
					global $`=var_name_mdpt`row'' "mdpt`row'"						  
				}  																	  
				else {  
				}      
			}       
			if "$`=var_name_mdpt`row''"=="" {  
			}       
		}        
		         
		local ++row  
		capture confirm scalar var_name_mdpt`row'									  
	}         
	          
	if `row'>1 {  
		foreach var of varlist `allvars' {  
			if strpos("$$`var'","mdpt")==0 {  
				global $`var' "mdpt`row'"  
				local ++row  
			}       
		} 	      
	}         
	          
	if `row'==1 {  
		local m=1			  
		foreach var of varlist `allvars' {  
			global $`var' "mdpt`m'"  
			local++m  
		} 	      
	}         
}          
if `resultreport'==0 {																	  
	foreach num of numlist 1 2 3 4 5 6 7 8 10 {  
		foreach var in ``vt_`num''vars'  {  
			local var_statatype 	`: type `var''												  
			local var_format 		`: format `var''											  
			scalar data_original_format_$$`var'= "`var_statatype' `var_format'"					  
		} 	      
	}         
	if "`nocompress'"=="" {  
		`text_i' "Compress data set for report `reportname', the following variables have been changed:" _n  
	    compress, nocoalesce  
		di       
	}  	      
	          
	foreach num of numlist 1 2 3 4 5 6 7 8 10 {  
		dq_int_var2 , varchecklist(``vt_`num''vars') tablename(integtable_studydata) row(integtablerows_studydata) stringvars(`stringvars') vartype(`num')  indent(`indent')  
		local stringvars="`r(stringvars)'"	  
		local remove_time =trim("`remove_time' `r(remove_time)'")  
		if `reportstop'==0 local reportstop = "`r(reportstop)'"  
	}         
	          
}          
if `resultreport'==0 {																	  
	          
	if "`stringvars'"~="" {  
		foreach num of numlist 1 2 3 4 5 6 7 8 10 {  
			foreach var in ``vt_`num''vars'  {  
				foreach str in `stringvars'  {  
					if strpos("``vt_`num''vars'","`str'")>0 {  
						local `vt_`num''vars=subinstr("``vt_`num''vars'","`str'","",1)  
						local  `vt_`num''varnumber = ``vt_`num''varnumber'-1  
						scalar `vt_`num''varnumber = ``vt_`num''varnumber'							  
					}     
				} 	    
			} 	     
		}        
		dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) colcontent1("$Note_1") colcontent2("String $Variable_1") colcontent3($DQ_INT_note_27: `stringvars')  indent(`indent')		  
	}         
	if "`timevars'" ~="" {  
			foreach str in `remove_time'  {  
				if strpos("`timevars'","`str'")>0 {  
					local timevars=subinstr("`timevars'","`str'","",1)  
					local  timevarnumber = `timevarnumber'-1  
					scalar timevarnumber = `timevarnumber'						  
			}       
			} 	     
	}         
	          
	if "`timevars'" =="" & (am_rowsum[7,1]+am_rowsum[8,1])>0 {  
			capture drop _case_order_  
			gen _case_order_=_n																	  
			lab var _case_order_ "Order of cases in data set. Auxiliary time variable."  
				dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) colcontent1($Note_1) colcontent2($vt_5: `timevars') ///  
												colcontent3("$helpaction_action_1") vartype(time)    indent(`indent') 		  
			local timevars="_case_order_"														  
	}         
	local clustervars= strtrim("`observervars' `devicevars' `centervars'")  
	local clustervarnumber=wordcount("`clustervars'")  
	scalar clustervarnumber = `clustervarnumber'  
	local outcomevars="`keyvars' `minorvars' `processvars' `controlvars'"  
	if trim("`outcomevars'") =="" {										//	If no useful analysis variable available  
		*** DQ_quality_decision: 	DQ_INTcall_7	  
		di as error "Critical: The used variable selection does not contain a useful outcome variable."  
		*di as error "Data Quality Classification:  Indicator: Insufficient programm call; Implementation form: No outcome variable "  
		dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) colcontent1("$Critical_1") colcontent2("$DQ_INTcall_critical_9") colcontent3($DQ_INTP_issue_5)  indent(`indent')		  
		local reportstop=1  
	}         
	          
	          
	if `reportstop'==1 	exit 	  
		         
	scalar outcomevarnumber=wordcount("`outcomevars'")  
	local allvars="`keyvars' `minorvars' `processvars' `controlvars' `timevars' `clustervars' `casemissvars' "  
	if "`timevars'"=="_case_order_"  local allvars="`keyvars' `minorvars' `processvars' `controlvars' `clustervars' `casemissvars'"  
	dq_hlp_dds1, cleanstring("`allvars'") nowarn(1)   indent(`indent')  
	local allvars "`r(cleanstring)'"  
	scalar allvarnumber=wordcount("`allvars'")  
	          
	if `clustervarnumber' > 0 dq_set_cl1 `clustervars', clustercolorpalettes(`clustercolorpalettes')  indent(`indent')  
	          
	          
	capture ds merge*					  
	if _rc>0	keep `keyvars' `minorvars' `processvars' `controlvars' `timevars' `clustervars' `casemissvars' `constvars' id_unique  
	if _rc==0	keep `keyvars' `minorvars' `processvars' `controlvars' `timevars' `clustervars' `casemissvars' `constvars' id_unique merge*  
	          
	          
	local mallvars 		""															  
	local moutcomevars 	""															  
	forvalues n=1/10 {																  
		if trim("``vt_`n''vars'")~="" {													//	If variables exist  
			local m`vt_`n''vars=""													//	Create empty local for respective variable type for modified variable lists  
			local vargroup "``vt_`n''vars'"											  
			foreach var of varlist `vargroup'  {  
					if strpos("`allvars'","`var'")>0 {  
					local m=0														  
					capture confirm variable m`var'  
									  
					if _rc==198 {  
						local replacename = substr("`var'",1,31)  
						local m=11  
					}     
					      
					if _rc==0  {													  
						     
						local m=0  
						local replacename "`var'"								  
						while `m'<10 {  
							local m=`m'+1  
							local replacename  "`replacename'_"					  
							if strlen("`replacename'")>31 local replacename = substr("`var'",-31,.)  
							capture confirm variable `replacename'  
							if _rc>0  {  
								capture confirm variable m`replacename'  
								  if _rc>0  local m=11							  
							}	  
						}    
					}     
					if `m'==11 {  
						rename `var' `replacename'  
						     
						     
						     
						local outcomevars=subinstr("`outcomevars'","`var'","`replacename'",1)  
						local allvars=subinstr("`allvars'","`var'","`replacename'",1)  
						local `vt_`n''vars=subinstr("``vt_`n''vars'","`var'","`replacename'",1)		  
						     
						     
						global `replacename' "$`var'"							  
						local var `replacename'									  
						     
						if "`reporttemplate'"~="D"{  
							*** DQ_process_decision: 	DQ_INTP_1  
							dq_out_add ,  tablename(integtable_analysisconduct) row(integtablerows_analysisconduct) columns(3) ///  
									colcontent1("$Action_1") colcontent2("`var'") colcontent3($DQ_INTP_action_1) vartype("`n'")  indent(`indent')  
							*local stop=1				  
						}    
					}     
					      
					qui clonevar m`var'=`var'									  
					local  m`vt_`n''vars "`m`vt_`n''vars' m`var'"				  
					local  mallvars  "`mallvars' m`var'"						  
					if `n'<= 4 local  moutcomevars  "`moutcomevars' m`var'"		  
				       
				}	     
			}       
		}	//	End loop if variables exist in respective type  
	}	        
	if `stop'==1 exit  
	local alloutcomevars="`outcomevars' `moutcomevars'"  
	          
	foreach var of varlist `allvars' {  
		local m_var m`var'  
		global m`var' m$`var'										  
		global 	m$`var'	$$`var'		  
		global 	$$`m_var'  $`var'  
	} 	       
	forvalues n=1/11 {															  
		if "``vt_`n''vars'"~="" {								  
		         
			foreach var of varlist ``vt_`n''vars' {  
				local pointer "$`var'"         					  
				       
				global vtnum_`pointer' =`n'						  
				global vtname_`pointer' ="`vt_`n''"				  
				       
				global vtnum_m`pointer' =`n'					  
				global vtname_m`pointer' ="`vt_`n''"			  
				       
				local vt_number="vtnum_`pointer'"				  
				local vtname="vtname_`pointer'"					  
				local vtname_output="vt_$`vt_number'"			  
				local vt_mnumber="vtnum_m`pointer'"				  
				local vtmname="vtname_m`pointer'"					  
			}       
		//outer standard loop	  
		}	       
	}	        
	          
	forvalues n=0/8 {															  
		local all_`vt_`n''vars="``vt_`n''vars' `m`vt_`n''vars'" 				  
	}         
	          
	          
	global ob "$vt_6"  
	global de "$vt_7"  
	global ce "$vt_8"  
	          
	local nc=0													  
	local allclvars ""											  
	forvalues n=6/8 {											  
		tokenize ``vt_`n''vars'  
			while "`1'"~="" {	  
				local ++nc  
				local pointer "$`1'"          					  
				global stcl`pointer' "`vts_`n''`nc'"			  
				local cl stcl`pointer'  
				local vtname_output "vt_`n'"  
				global $`cl' "$`vtname_output'"					  
				local bp="vp_$`cl'"								  
				global `bp'="`1'"								  
				local allclvars "`allclvars' $`cl'"  
				macro shift		  
			}	      
	}	        
}          
           
	          
* Useful scope: 	scalelevel  missinglist jumplist key_observer key_device key_datetime  
if `resultreport'==0 {																	  
	* Not useful: 		var_name varlabel varshortlabel refcat eventcat var_order  
	* Not possible: 	limit_soft_low limit_soft_up limit_hard_low limit_hard_up value_label variablerole  
	          
	* Loop only for original variables useful because cloned are adressed within ado dq_met_lab1  
	dq_met_lab1 `allvars' ,  maxvarlabellength(`maxvarlabellength')  indent(`indent')  
	          
	dq_met_lab2 `allvars' ,   indent(`indent')  
	forvalues n=1/4 {														  
		tokenize ``vt_`n''vars'	 											  
		while "`1'"~="" {	  
			local pointer "$`1'"          									  
			foreach scalarstub in observer device time {  
				capture confirm scalar  key_`scalarstub'_$`pointer' 		  
				if  _rc>0 {  
				    scalar key_`scalarstub'_$`pointer' = "``scalarstub'vars'"  
				}      
			}  //end loop ove stubtypes  
			macro shift		  
		}	       
	}         
	          
	foreach n of numlist 1 2 3 4 5 6 7 8 10 {								  
		tokenize ``vt_`n''vars'	 											  
		while "`1'"~="" {	  
			if "$`1'"~="" {  
				qui capture confirm scalar variablerole_$$`1' 		  
				if _rc==0	{  
				}      
				if  _rc>0 {  
					scalar variablerole_$$`1' = "`vt_`n''vars"  
				}      
			}       
			macro shift		  
		}	       
	}         
	          
			        
}          
           
if `resultreport'==0 &  am_allsum[1,1]>0  {  
	*** Create scalars to store number of changes in variables  
	foreach var of varlist `allvars' {  
		local pointer "$`var'"         						  
		scalar changeall_`strata'_`pointer'=0				  
		scalar changebinaryrecode_`strata'_`pointer'=0		  
		scalar changemiss_`strata'_`pointer'=0				  
		scalar changerv_`strata'_`pointer'=0				  
		scalar changeextreme_`strata'_`pointer'=0			  
	} 	       
	dq_met_mis1 `allvars' `mallvars', itemmisslist(`itemmisslist') itemjumplist(`itemjumplist') ststrata(`strata')  indent(`indent')  
			        
	dq_des_var1 `allvars' `subgroup', structure(`strata')   indent(`indent') suppress(1)  
	foreach n of numlist 1 2 3 4 5 6 7 8 10 {											  
		tokenize ``vt_`n''vars'	 											  
		local metricvars`n'=""												  
		local mmetricvars`n'=""												  
		while "`1'"~="" {	  
			if "$`1'"~="" {  
				qui capture confirm scalar scalelevel_$$`1'  
				if _rc==0 {  
				}      
				if _rc>0  {  
				       
						if `n'==6 | `n'==7 | `n'==8  | `n'==10  scalar scalelevel_$$`1'="nominal ($assigned_1)"  
						if `n'==5 	scalar scalelevel_$$`1'="interval ($assigned_1)"		  
						qui capture confirm scalar scalelevel_$$`1'  
						if _rc==0 {  
						}    
						if _rc>0  {  
							if `=vp_levels_`strata'_$`1''>`metriclevels' & `=vp_min_`strata'_$`1''>=0 {  
								scalar scalelevel_$$`1'="ratio ($assigned_1)"  
							}   
							if `=vp_levels_`strata'_$`1''>`metriclevels' & `=vp_min_`strata'_$`1''<0 {  
								scalar scalelevel_$$`1'="interval ($assigned_1)"  
							}			  
							if `=vp_levels_`strata'_$`1''<=`metriclevels' & `=vp_levels_`strata'_$`1''>`binaryrecodelimit' {  
								scalar scalelevel_$$`1'="ordinal ($assigned_1)"  
							}				  
							if `=vp_levels_`strata'_$`1''<=`metriclevels' & `=vp_levels_`strata'_$`1''<=`binaryrecodelimit' {  
								scalar scalelevel_$$`1'="nominal ($assigned_1)"  
							}		  
						}    
						     
						     
				}      
				if  strpos("`=scalelevel_$$`1''","interval")>0 | strpos("`=scalelevel_$$`1''","ratio")>0 {  
					local metricvars`n' ="`metricvars`n'' `1'"								  
					local mmetricvars`n'="`mmetricvars`n'' m`1'"								  
				       
				}      
			}       
			macro shift	  
		}	       
	}         
           
	if `binaryrecodelimit'>0 dq_dm_brec `outcomevars', strata(`strata') jumpto0recode(`jumpto0recode')  indent(`indent')  
	          
	qui dq_out_mac , text(lim_)		  
	if `r(macrocount)'>0  {  
		dq_con_rv1 `allvars', ststrata(`strata') metadatafile(`metadatafileexist') nomod(`nomod')  indent(`indent')  
	}         
	if am_rowsum[6,1]>0  {  
		dq_des_var1 `moutcomevars', structure(`strata') suppress(1)  indent(`indent') 			  
		dq_acc_uo1 `moutcomevars', structure(`strata') nomod(`nomod') outcheck(`outcheck') outsens(`outsens') outintegrate(`outintegrate') ///  
					decimals(`decimals') gdth(`gdth') histkat(`histkat') forcecalc(`forcecalc')  indent(`indent')  
	}         
	foreach var of varlist `allvars' {  
		local pointer "$`var'"         							  
		scalar changeall_`strata'_`pointer' = changerv_`strata'_`pointer'+changeextreme_`strata'_`pointer'+changemiss_`strata'_`pointer'+changebinaryrecode_`strata'_`pointer'  
	} 	       
}          
	          
if `resultreport'==0 & am_allsum[1,1]>0  {  
	          
	`text_i' "Main Analyses for report `reportname'" _n  
	dq_com_cas `subgroup', casemissvars(`casemissvars') casemisstype(`casemisstype') casemisslogic(`casemisslogic') structure(`strata') minreportn(`minreportn')  indent(`indent')  
	if `r(reportstop)'==1 exit  
	forvalues n=1/10 {													  
		`text_i' "Variable related calculations for the group `n': `vt_`n''" _n  
			        
		if "``vt_`n''vars'"~=""  & ``vt_`n''varnumber'>0 {   			//Exlude with ``vt_`n''varnumber'>0  sections with only artificially created variables  
			        
			forvalues m=0/1 {											  
				if `m'==0 local o ""									  
				if `m'==1 local o "m"									  
				if "``o'`vt_`n''vars'"~="" {							  
				       
					if `m'==0 `text_i' "Calculations for the original variables:  ``o'`vt_`n''vars'" _n  
					if `m'==1 `text_i' "Calculations for the modified variables:  ``o'`vt_`n''vars'" _n			  
					if `n'<11 	dq_com_im1 ``o'`vt_`n''vars' `subgroup',  structure(`strata')  indent(`indent')  
					dq_des_var1 ``o'`vt_`n''vars' `subgroup', structure(`strata')  indent(`indent')  
					      
					foreach var of varlist  ``o'`vt_`n''vars' {				  
						local pointer "$`var'"         						  
						     
						capture confirm scalar key_datetime_$`pointer'  
						if _rc==0 {  
							if trim("`=key_datetime_$`pointer''")~="" local timeusevar "`=key_datetime_$`pointer''"  
								else local timeusevar ""						  
						}    
						else local timeusevar "`timevars'"	  
						if "`timevars'"=="_case_order_" local timeusevar "_case_order_"		  
					      
						if view_varoverview[1,`n']==1 	& `m'==0		///  
									dq_des_gh1 `var' `subgroup', ststrata("`strata'") gd(`gdth') histkat(`histkat') forcecalc(`forcecalc') thumbs(1)  indent(`indent')	  
						if view_variabledescriptive[1,`n']==1 & `m'==0 	///  
									dq_des_gh1 `var' `subgroup', ststrata("`strata'") gd(`gd') histkat(`histkat') forcecalc(`forcecalc')  indent(`indent')	  
						     
						if `n'<5 {  
							local varclusterlist =strtrim("`=key_observer_$`pointer'' `=key_device_$`pointer''")		  
						}    
						if view_timetrend[1,`n']==1 & "`varclusterlist'"=="" & (`n'<5 | `n'==11) & `m'==1 & `=vp_N_`strata'_`pointer''>0  {  
							local lsetting "legend(0) calc(-1)"		  
							if `n'==11 {  
								local lsetting `" gname(lowesslegend_tt) lc(1) legend(1) calc(0)"' 	  
								local obscheck_regtype 0  
							}   
							    
							if "`timeusevar'"~="" & strtrim("`timeusevar'")~="`var'" {  
								dq_acc_tt1  `var' `subgroup', obs() t(`timeusevar') controlvars(`controlvars') ststrata("`strata'") stcluster("tt")  sdfac(2) 		///  
												bwb(0.5) bcase(200) minobs(`minclustersize_lowess') minevent(`minevent_lowess') minclustersize_icc(`minclustersize_icc') 			///  
												labeldep("") forcecalc(`forcecalc')	gpath("`gd'") gwidth($graphfullpagewidth) gheight($graphhalfpageheight) `lsetting'				///  
												 indent(`indent')  
							}   
						}    
						     
						     
						if `clustervarnumber'>0  & `m'==0 & (`n'<5 | `n'==11) & `=vp_N_`strata'_`pointer''>0 & view_varcrosstab[1,`n']==1  {	  
							foreach cluster of varlist `clustervars' {		  
							    
								capture reg `var' i.`cluster'  
								local noobs_cluster=_rc  
								if `noobs_cluster'==2000 {  
								}									  
																						  
								if strpos("`varclusterlist'","`cluster'")>0 &  `noobs_cluster'==0  {  
									local clpointer "$`cluster'"      		  
									local cl stcl`clpointer'					  
										  
									dq_des_gc1 `var' `subgroup', clustervar(`cluster') ststrata("`strata'") stcluster("$`cl'") gd(`gd') ///  
																 indent(`indent') forcecalc(`forcecalc')  
									if `r(gc1graph)'==1 {  
										dq_des_gc1 `var' `subgroup', clustervar(`cluster') ststrata("`strata'") stcluster("$`cl'") gd(`gd') ///  
																	 indent(`indent') forcecalc(`forcecalc')	percent(0)										  
									}	  
																  
								}  
							}   
						}    
						     
						     
						     
						     
						* Check if there are cluster variables, and only analyses for first five categories and the constant, and if observations available HOTFIX remove n=11 options  
						if `clustervarnumber'>0  & `m'==1 & (`n'<5 | `n'==11) & `=vp_N_`strata'_`pointer''>0 {	  
								   
							foreach cluster of varlist `clustervars' {		  
								if strpos("`varclusterlist'","`cluster'")>0 {  
									local clpointer "$`cluster'"      		  
									local cl stcl`clpointer'					  
									  
									capture reg `var' i.`cluster'  
									local noobs_cluster=_rc  
									if `noobs_cluster'==2000 {  
									}  
									if `noobs_cluster'==0 {  
										local perfectpredict_cluster=e(r2)  
										if `perfectpredict_cluster'>.99999 {  
											`text_i' "A perfect prediction of the outcome `var' by the cluster `cluster' was encountered and analyses related to clusters is suspended."  
										}  
									}  
									  
									if "`controlvars'"~= "" {  
										capture reg `var' `controlvars'  
										local noobs_control=_rc  
										if `noobs_control'==2000 {  
											`text_i' "WARNING: No observations for outcome `var' cluster `cluster' and control variable, control variable(s) `controlvars' excluded."  
											local controlvarspass ""  
										}  
										if `noobs_control'==0 {  
											local perfectpredict_controlvars=e(r2)  
											if `perfectpredict_controlvars'>.99999 {  
												`text_i' "WARNING: A perfect prediction of the outcome `var' by the control variables `controlvars' was encountered and control variables are omitted."  
												local controlvarspass ""  
											}  
											else local controlvarspass "`controlvars'"								  
										}  
									}  
						     
									* not yet dq_help_predictionchecker `var', catpredict() contpredict(`cluster')  
		         
									  
									if `=vp_levels_`strata'_`clpointer''>1 & `noobs_cluster'==0  {			  
										  
										 if view_icc1[1,`n']==1 & `perfectpredict_cluster'<.99999  {						  
											dq_acc_ic1 `var' `subgroup', cluster(`cluster') ststrata("`strata'") stcluster("$`cl'")  ///  
													controlvars(`controlvarspass') minclustersize_icc(`minclustersize_icc')  indent(`indent') forcecalc(`forcecalc')  
										 }  
										  
										if view_icc2[1,`n']==1 & "`centervars'"~="`cluster'" & `centervarnumber'>0 & `perfectpredict_cluster'<.99999 {	  
											dq_acc_ic2 `var' `subgroup', cluster_l3(`centervars') cluster_l2(`cluster') ststrata("`strata'") stcluster("$`cl'")  ///  
													controlvars(`controlvarspass')  indent(`indent') forcecalc(`forcecalc')  
										}  
										if view_varsubgroup[1,`n']==1  & `perfectpredict_cluster'<.99999 {  
											dq_acc_mp1 `var' `subgroup', clustervar(`cluster') controlvars(`controlvarspass') ststrata("`strata'") stcluster("$`cl'") gd(`gd') ///  
													minclustersize(`minclustersize_icc')  indent(`indent') forcecalc(`forcecalc') warncolor(`warncolor')  
										}  
										  
										  
										if view_timetrend[1,`n']==1 & (`perfectpredict_cluster'<.99999 | `n'==11) & ("`timeusevar'"~="") {  
											local lsetting "legend(0) calc(-1)"		  
											if `n'==11 {  
												local lsetting `" gname(lowesslegend_$`cl') lc(1) legend(1) calc(0)"' 	  
												local obscheck_regtype 0  
											}  
											dq_acc_tt1  `var' `subgroup', obs(`cluster') t(`timeusevar') controlvars(`controlvarspass') ///  
														ststrata("`strata'") stcluster("$`cl'")  sdfac(2) 												///  
														bwb(0.5) bcase(200) minobs(`minclustersize_lowess') minevent(`minevent_lowess') minclustersize_icc(`minclustersize_icc') 		///  
														labeldep("") forcecalc(`forcecalc')	 indent(`indent')													///  
														gpath("`gd'") gwidth($graphhalfpagewidth) gheight($graphhalfpageheight) `lsetting'  
										}  
										  
									}  
								}  
							}   
						}    
						     
						     
					      
					}     
				}	     
			}       
			//END outer standard loop	  
			        
		}        
	}	        
}          
	          
	          
if `resultreport'==0 & am_allsum[1,1]>0  {  
	forvalues  n =2/`=dqi_number_mddq' {		  
		foreach var of varlist `allvars'  {  
			if "`=dqi_dimension_mddq`n''"=="Accuracy" {  
				local m "m"  
			}       
				else {  
					local m ""  
				}      
			        
			local mvar "`m'`var'"																				  
			local pointer "$`mvar'"  
			        
			*foreach str of local strata {		 HOTFIX currently disableb because no proper STRATA use			  
				local checkresult "`=dqi_parameterstub_mddq`n''_`strata'_`pointer'"								  
				       
				if strpos("`checkresult'","icc")==0	{															  
					      
					dq_hlp_dqi1 `m'`var', checkresult(`checkresult')  indent(`indent') icount(`n') structure(`strata')	  
					      
				}      
				       
				if strpos("`checkresult'","icc")>0 {															  
					foreach cl of local allclvars  {															  
						     
						local checkresult "`=dqi_parameterstub_mddq`n''_`strata'_`cl'_`pointer'"			  
						     
						dq_hlp_dqi1 `m'`var', checkresult(`checkresult')  indent(`indent') icount(`n') structure(`strata'_`cl')  
						local resultfound=`r(resultfound)'  
					}     
				}      
				       
			*}      
		} 	      
	}         
			        
}          
	          
	          
if `resultreport'==0 &  am_allsum[1,1]>0 & `problemvarreport'>-1 {  
	if "`rdd'"~="" {  
		qui capture save "`rdd'\`reportname'_dataresults.dta", replace  
		if _rc>0 `text_i'  "Modified study data file could not be saved in `rdd'\`reportname'_dataresults.dta"  
			else `text_i'  "Save modified study data file in the result data directory `rdd'\`reportname'_dataresults.dta"  
	}         
	clear																		  
	local rows= `=allvarnumber'*2												  
	qui set obs `rows'																  
	qui gen pointer=_n																  
	          
	qui gen modified=0																  
	qui replace modified=1 if pointer>`=allvarnumber'  
	local scalarlist: all scalars  
	foreach var of local scalarlist {  
		if strpos("`var'","mdpt")==0 &  strpos("`var'","S_E_")==0 {				  
			local modified=0													  
			local checkstr=subinstr("`var'", "_pt", " ",.)						  
			if wordcount("`checkstr'")==1  {									  
				local checkstr=subinstr("`var'", "_mpt", " ",.)					  
				local modified=1												  
			}       
			if wordcount("`checkstr'")>1  {										  
				tokenize "`checkstr'"											  
				capture confirm variable `1'									  
				if _rc>0 {														  
					capture gen  str `1'="a123456789012345678901234567890a"		  
					qui replace `1'=""												  
				}      
				local row=`=allvarnumber'*`modified'+`2'						  
				       
				qui capture confirm numeric variable `1'  
				if _rc>0  qui replace `1'="`=`var''" if pointer==`row'				  
				if _rc==0 qui replace `1'= `=`var''  if pointer==`row'				  
			}       
		}        
	}         
	foreach var of varlist _all {  
			qui tab `var', nofreq														  
			if r(N)==0 {  
				drop `var'												  
			}       
	}         
	          
	qui replace pointer=pointer- modified*`=allvarnumber'							  
	sort pointer modified  
	qui gen reportname="`reportname'"									  
	if "`segmentname'"=="" qui gen segmentname="`reportname'"				  
	if "`segmentname'"~="" qui gen segmentname="`segmentselect'"										  
	qui gen subgroupname="`subgroupname'"  
	qui gen originaldataset_varnum="`=originaldataset_varnum'"  
	qui gen dataset_initalobsnum="`=dataset_initalobsnum'"  
	qui gen dataset_obsnum="`=dataset_obsnum'"  
	*** Transfer results from scalars to variables  
	qui gen variablerole="placeholder"  
	qui gen variable_rolenumber="placeholder"		  
	qui gen scalelevel="placeholder"		  
	qui sum pointer  
	forvalues n=1/`r(max)' {  
	   local vtname "vtname_pt`n'"  
	   local vt_number "vtnum_pt`n'"  
	   qui replace variablerole="$`vtname'"+"vars" if `n'==pointer  
	   qui replace variable_rolenumber="$`vt_number'" if `n'==pointer  
	   local pt "pt`n'"  
	   qui replace scalelevel="`=scalelevel_$`pt''" if `n'==pointer  
	}         
	foreach clustertype in observer device time {  
		capture drop key_`clustertype'  
		qui gen key_`clustertype'="nondefined"  
		foreach var of local alloutcomevars {  
			qui replace key_`clustertype'="`=key_`clustertype'_$$`var''" if var_name=="`var'"  
		}        
	}         
	quietly destring _all, replace										  
	lab def vtn 1 "$vts_1" 2 "$vts_2" 3 "$vts_3" 4 "$vts_4" 5 "$vts_5" 6 "$vts_6" 7 "$vts_7" 8 "$vts_8" 9 "$vts_9" 10 "$vts_10" 11 "$vts_11"  
	lab val variable_rolenumber vtn  
	* tab variablerole variable_rolenumber  
	capture drop variable_roleshort  
	qui recode  variable_rolenumber (4/8=4) (9/12=.), gen(variable_roleshort)  
	lab def vtn2 1 "$vts_1" 2 "$vts_2" 3 "$vts_3" 4 "$other_1"  
	lab val variable_roleshort vtn2  
	* tab variable_roleshort  variablerole  
	***	DQ classification and result aggregation function  
	dq_hlp_dqr1 , strata(`strata')  indent(`indent')  
	*** Assign variable labels to converted scalar content  
	dq_hlp_svl, varlabs(1) structure("`strata'") clustervars(`allclvars' ob de ce) decimals(`decimals') ///  
				outcheck(`outcheck') outsens(`outsens') outintegrate(`outintegrate')  indent(`indent')  
	qui drop if variable_rolenumber==11		  
	qui drop if var_name==""				  
	*qui drop refcat_*					  
	          
	          
	local structuralvarorder "reportname segmentname subgroupname dataset_* variablerole variable_rolenumber variable_roleshort var_name varlabel varshortlabel "  
	          
	qui ds, varwidth(32) alpha  
	order `r(varlist)'  
	local sortorder  refcat* change* key_* dqi_varmax*																		///  
					 vp_N* vp_levels* vp_mean* vp_sd* vp_min* vp_max* vp_range* vp_p* vp_iqr* vp_rm* vp_kurt* vp_skew*		///  
					 im1_any* im1_nrr* im1_rr* im1_jump* im1_uncl* im1_valid* im1_sysm* im1_refu* im1_noex* im1_sh* 		///  
					 rv1*																									///  
					 uo1* 																									///  
					 icc1_fe* icc1_re* icc1_N* icc1_clall*  icc1_clused* icc1_min* icc1_mean* icc1_max*						///  
					 icc2_fe* icc2_re* icc2_N* icc2_clall*  icc2_clused* icc2_min* icc2_mean* icc2_max*						///  
					 tt1*																									///  
					 graph*  
					      
	*Assess existence of variables  
	local resultvarorder ""  
	foreach stub in `sortorder' {  
		qui capture ds `stub'  
		if _rc==0 {  
			local resultvarorder "`resultvarorder' `stub'"  
		}        
	}         
	          
	*Order variables in file  
	order  `structuralvarorder' modified pointer  `resultvarorder'  
	local resultscalarfilelong "Resultscalars_`reportname'_`subgroupreference'_`reporttemplate'_long.dta"  
	qui save "`srdd'\`resultscalarfilelong'", replace  
	export delimited using "`srdd'\`resultscalarfilelong'.csv", replace  
	          
	foreach var of local resultvarorder {  
		qui capture ds `var'1  
		if _rc==0 {  
			rename `var' `var'_  
		}        
	}	        
	          
	reshape wide `structuralvarorder' `resultvarorder', i(pointer) j(modified)  
	foreach var of local structuralvarorder {  
		rename `var'0 `var'  
		drop `var'1  
	}         
	foreach var of local resultvarorder {  
		qui sum `var'0  
		if r(N)==0 drop `var'0  
		qui sum `var'1  
		if r(N)==0 drop `var'1  
	}         
	local resultscalarfile "Resultscalars_`reportname'_`subgroupreference'_`reporttemplate'_wide.dta"  
	qui save "`srdd'\`resultscalarfile'", replace  
	export delimited using "`srdd'\`resultscalarfile'.csv", replace  
	          
	use "`srdd'\`resultscalarfilelong'", clear  
	          
}          
	* value_label data_type scalelevel missinglist jumplist refcat eventcat  
*** Loop over data quality indicators to create graphs - this selects the parameter this section uses the stored variables not the scalars  
if `view_dqi'==1 {  
	local stratavar "variable_roleshort"								  
	if `benchmark'>0 local stratavar "segment"				  
	          
	if `resultreport'==1 & "`ststrata'"~="" {  
		capture noisily confirm variable `ststrata'  
		if _rc==0 local stratavar "`ststrata'"  
	}         
	          
	          
	forvalues  n =1/`=dqi_number_mddq' {		  
			*foreach str of local strata {		HOTFIX currently disabled because no proper STRATA use			  
				local checkresult "`=dqi_parameterstub_mddq`n''_`strata'_dqi"								  
				if strpos("`checkresult'","icc")==0	{												  
					capture confirm variable `checkresult'  
					if _rc==0 {  
						qui count if `checkresult'<.  
						if r(N)>0 {	  
							dq_des_dqg1 `checkresult', stratavar("`stratavar'") gd(`gddq') structure(`strata') dqinumber(`n') reportname(`reportname') forcecalc(1)  indent(`indent')  
						}    
					}     
					else  
				}      
				else {																				  
					foreach cl in ob de ce  {														  
						local checkresult "`=dqi_parameterstub_mddq`n''_`strata'_`cl'_dqi"					  
						     
						capture confirm variable `checkresult'  
						if _rc==0 {  
							qui count if `checkresult' <.  
							if r(N)>0 {	  
								dq_des_dqg1 `checkresult', stratavar("`stratavar'") gd(`gddq') structure(`strata') dqinumber(`n') reportname(`reportname') forcecalc(1)  indent(`indent')  
							}   
						}    
						else  
					}     
				}      
			*}      
	}         
}          
	          
*** Generate auxilliary output files, Manual Edits file scalar description files  
if `resultreport'==0  {  
	dq_out_log,  indent(`indent')  
	sort modified pointer  
	qui sum pointer  
	local maxvar=r(max)  
	local manualeditvars "Ampelfarbe dqi_final"  
	foreach string in  `manualeditvars' {  
		capture gen `string'=.  
	}         
	local outputvarlist reportname segmentname subgroupname variablerole var_name varlabel `manualeditvars'  
	local loop 1  
	while `loop'>0 {  
		capture confirm scalar dqi_parameterstub_mddq`loop'  
		if _rc>0 local loop=0  
		if _rc==0 {  
			local searchterm "`=dqi_parameterstub_mddq`loop''*"  
			capture ds `searchterm'  
			if _rc==0 local outputvarlist "`outputvarlist' `r(varlist)'"  	  
			local ++loop  
		}        
	}         
	*qui sum `outputvarlist'  
	*order `outputvarlist'  
	* Compute scalar properties and store them in a result scalar section -> This is done before removing the modified variables  
	dq_des_sp1,  indent(`indent')  
	* Output all scalar properties  
	*dq_out_mac, ld("`ld'") exportname("all_scalars")  indent(`indent')  
	          
	foreach var in  `outputvarlist' {  
		forvalues target=1/`maxvar'  {  
			local reference=`target'+`maxvar'  
			local targetvalue= `var'[`target']					  
			local referencevalue= `var'[`reference']			  
			if "`targetvalue'"=="" | "`targetvalue'"=="."   qui replace `var' = `referencevalue' in `target'  
		}        
	}         
	qui drop if modified==1 							  
	*** Output Excel result scalar file  
	if "`srdd'"~="" {  
		qui export excel `outputvarlist'  using "`srdd'\Resultscalars_`reportname'_`subgroupreference'_resultedit.xlsx", sheet("editresult") firstrow(variables) nolabel replace  
		if strpos("`srdd'","__deletef")==0 `text_i' "Data quality assessment results saved to Excel file: `srdd'\Resultscalars_`reportname'_`subgroupreference'_resultedit.xlsx" _n  
	}         
	          
	qui drop `manualeditvars'  
	*** Return scalar description files  
	* Output dqi scalar properties  
	if "`srdd'"~="" {  
		dq_out_mac, text(sU_) srdd("`srdd'") exportname("dqi_scalars_`reportname'_`reporttemplate'")  indent(`indent')  
	}         
	          
	* Save description of summary result scalar file and delete previous content  
	describe, replace clear  
	if "`srdd'"~="" {  
		qui capture export excel using "`srdd'\Resultscalaroverview_`reportname'_`reporttemplate'.xlsx", firstrow(variables) replace  
		if strpos("`srdd'","__deletef")==0  `text_i' "Data quality assessment result scalar overview saved to: `srdd'\Resultscalaroverview_`reportname'_`reporttemplate'.xlsx" _n  
	}         
}          
			        
if  "`reportformat'"~="noreport"	 {  
	scalar minclustersize_icc = `minclustersize_icc'   	  
	dq_hlp_mcr,  macrotype(1) 	 indent(`indent')		  
	dq_hlp_mcr,  macrotype(2) 	 indent(`indent')		  
	capture scalar drop minclustersize_icc 				  
	dq_set_tab1, outcheck(`outcheck') decimals(`decimals')  indent(`indent')  
	local tablepointer =0	  
	if `resultreport'==0  use "`srdd'\`resultscalarfilelong'", clear  
	          
	if `view_dqi'==1 {  
		forvalues  n =1/`=dqi_number_mddq' {		  
			        
			local dqicaptiontext "$Categories_1 $for_1 `=dqi_statistics_mddq`n'': "  
			forvalues cat=1/`=dqi_catnum_mddq`n'' {		  
				capture confirm scalar dqi_cat_`cat'_mddq`n'  
				if _rc==0 {																			  
					if "`=dqi_cat_`cat'_mddq`n''"~="" local dqicaptiontext = "`dqicaptiontext'`=dqi_cat_name_`cat'_mddq`n'': `=dqi_cat_`cat'_mddq`n''; "  
					local dqicaptiontext = subinstr("`dqicaptiontext'", "  ", " ", .)					  
				}      
			}       
		         
			if `n'==1 & "`=dqi_cat_1_mddq`n'"~="" local dqicaptiontext = "$dqsummary1"  
						     
			*foreach str of local strata {		HOTFIX currently disabled because no proper STRATA use			  
				local checkresult "`=dqi_parameterstub_mddq`n''_`strata'_dqi"							  
				if strpos("`checkresult'","icc")==0	{												  
		         
					capture confirm variable `checkresult'											  
					if _rc==0  {  
						if `view_dqi'==1 {  
							    
							local tablename "table_dqi_`strata'"			  
							if "``tablename'_tr'"=="" {												  
								local `tablename'_tr=1												  
								local ++tablepointer												  
								local table`tablepointer'="`tablename'"								  
							}   
							if `resultreport'==0 local tabletexts=`"headertext($`=dqi_indicatorlabel_mddq`n'') subheadertext(.) captiontext(`dqicaptiontext')"'  
							if `resultreport'>0  local tabletexts=`"headertext(.) subheadertext(.) captiontext($`=dqi_indicatorlabel_mddq`n'') subcaptiontext(`dqicaptiontext')"'  
							    
							    
							dq_out_tab1, varlist(`checkresult')  tablename(`tablename')  tablerows(``tablename'_tr') memtable(1) gd(`gddq') 				///  
									structure("`strata'") `tabletexts' displaymodified(0) columnheader(0) varnameinfo(0) repeatheader(1) leavecaption(1)	///  
									$table_basic_dqi																				  
									  
							local `tablename'_tr = `r(tablerows)'									  
						}    
					}     
				}      
			        
				if strpos("`checkresult'","icc")~=0 {												  
					foreach cl in ob de ce  {													  
						local checkresult 	"`=dqi_parameterstub_mddq`n''_`strata'_`cl'_dqi"		  
						capture confirm variable `checkresult'  
						if _rc==0 {  
								if `view_dqi'==1 {  
								local tablename "table_dqi_`strata'"			  
								if "``tablename'_tr'"=="" {											  
									local `tablename'_tr=1											  
									local ++tablepointer  
									local table`tablepointer'="`tablename'"							  
								}  
								   
								if `resultreport'==0 local tabletexts=`"headertext($`=dqi_indicatorlabel_mddq`n'' $`cl') subheadertext(.) captiontext(`dqicaptiontext')"'				  
								if `resultreport'>0  local tabletexts=`"headertext(.) subheadertext(.) captiontext($`=dqi_indicatorlabel_mddq`n'' $`cl') subcaptiontext(`dqicaptiontext')"'				  
								dq_out_tab1, varlist(`checkresult')  tablename(`tablename')  tablerows(``tablename'_tr') memtable(1) gd(`gddq') 					///  
										structure("`strata'") `tabletexts' displaymodified(0) columnheader(0) varnameinfo(0) repeatheader(1) leavecaption(1) 				///  
										$table_basic_dqi	  
									  
								local `tablename'_tr = `r(tablerows)'								  
							}   
						}    
					}     
				}      
				*}     
		}        
	}         
			        
				       
	di _n(2)  
	dq_hlp_tst, tablestructure(basictable_dqi) searchstring(dqi) stringexclude(dqi_varmax) decimals(`decimals') benchmark(`benchmark')  indent(`indent')  
	local basictable_dqi=r(tablenum)		  
	forvalues n=1/8 {															  
		if "``vt_`n''varnumber'"=="" local `vt_`n''varnumber=0					  
		if "``vt_`n''vars'"~=""  & ``vt_`n''varnumber'>0 {   					//Exlude with ``vt_`n''varnumber'>0  sections with only artificially created variables  
		         
		         
			if `view_dqi'==1 & `basictable_dqi'>0 {								  
			        
				forvalues o=1/`basictable_dqi' {								  
					local tablename "table_dqi_numbers`o'_`strata'"				  
					if "``tablename'_tr'"=="" {									  
						local `tablename'_tr=1									  
						local ++tablepointer  
						local table`tablepointer'="`tablename'"					  
					}     
					local dqi_tablecolumns "basictable_dqi`o'"  
					if strpos("`dqi_tablecolumns'","icc")>0 local tabledqicaption1 "$tabledqicaption1 VP: $icc1_fe ;"  
					      
					dq_out_tab1   , varlist(``vt_`n''vars') tablename(`tablename')  tablerows(``tablename'_tr') memtable(1) gd(`gddq') 	///  
									structure("`strata'") captiontext(`tabledqicaption1')												///  
									vartype(`n')  resulttype(2) 									///  
									$`dqi_tablecolumns'   indent(`indent')  
									  
					local `tablename'_tr = `r(tablerows)'						  
				}      
			}       
			if view_varoverview[1,`n']==1 {  
				local tablename "table_vardescr_`strata'"				  
				if "``tablename'_tr'"=="" {									  
					local `tablename'_tr=1									  
					local ++tablepointer  
					local table`tablepointer'="`tablename'"					  
				}      
				dq_out_tab1   , varlist(``vt_`n''vars') tablename(`tablename')  tablerows(``tablename'_tr') memtable(1) gd(`gdth') 	///  
								structure("`strata'") captiontext("$manipulation_comment1")											///  
								vartype(`n')  $basictable_descriptives2  
								   
				local `tablename'_tr = `r(tablerows)'						  
			}       
				       
				       
			if view_missing[1,`n']==1 {  
				local tablename "table_missings_`strata'"				  
				if "``tablename'_tr'"=="" {									  
					local `tablename'_tr=1									  
					local ++tablepointer  
					local table`tablepointer'="`tablename'"					  
				}      
				dq_out_tab1   , varlist(``vt_`n''vars')  tablename(`tablename')  tablerows(``tablename'_tr') memtable(1) gd(`gd') 	///  
								structure("`strata'") captiontext("$missing_comment_1")												///  
								vartype(`n')  $basictable_missings1  
								   
				local `tablename'_tr = `r(tablerows)'						  
			}       
				       
			if view_missing_percent[1,`n']==1 {  
				local tablename "table_misspercent_`strata'"				  
				if "``tablename'_tr'"=="" {												  
					local `tablename'_tr=1												  
					local ++tablepointer  
					local table`tablepointer'="`tablename'"								  
				}      
				dq_out_tab1   , varlist(``vt_`n''vars') tablename(`tablename')  tablerows(``tablename'_tr') memtable(1) gd(`gd') 	///  
								structure("`strata'") captiontext("")																///  
								vartype(`n')  $basictable_missings2  
								   
				local `tablename'_tr = `r(tablerows)'									  
			}       
				       
	          
			if "`metricvars`n''"~="" {														  
						     
				capture qui ds(rv1*)													  
				if _rc==0 & view_rangeviolation[1,`n']==1  {  
					local tablename "table_rv_`strata'"				  
					if "``tablename'_tr'"=="" {											  
						local `tablename'_tr=1											  
						local ++tablepointer  
						local table`tablepointer'="`tablename'"							  
					}     
					dq_out_tab1   , varlist(`metricvars`n'') tablename(`tablename') tablerows(``tablename'_tr') memtable(1) gd(`gd') 	///  
									structure("`strata'") captiontext("")															///  
									vartype(`n')  $basictable_rangeviolation1  
									  
					local `tablename'_tr = `r(tablerows)'								  
				}      
				       
				capture qui ds(uo1*)													  
				if _rc==0 & view_univariateoutlier[1,`n']==1 & `n'<5 {  
					local tablename "table_uo_`strata'"				  
					if "``tablename'_tr'"=="" {											  
						local `tablename'_tr=1											  
						local ++tablepointer  
						local table`tablepointer'="`tablename'"							  
					}     
					      
					dq_out_tab1   , varlist(`mmetricvars`n'') tablename(`tablename') tablerows(``tablename'_tr') memtable(1) gd(`gdth') 	///  
									structure("`strata'") captiontext("$tableextremecaption1")											///  
									vartype(`n')  $basictable_univariateoutlier1  
									  
					local `tablename'_tr = `r(tablerows)'								  
				}      
				       
				if view_percentile[1,`n']==1 {  
					local tablename "table_varperc_`strata'"					  
					if "``tablename'_tr'"=="" {  
						local `tablename'_tr=1											  
						local ++tablepointer  
						local table`tablepointer'="`tablename'"							  
					}	    
					dq_out_tab1   , varlist(`metricvars`n'')  tablename(`tablename')  tablerows(``tablename'_tr') memtable(1) gd(`gd') ///  
								structure("`strata'") captiontext("$manipulation_comment1")											///  
								vartype(`n')  $basictable_percentiles1  
								   
					local `tablename'_tr = `r(tablerows)'								  
				}      
			}       
			        
			if (view_icc1[1,`n']==1  | view_icc2[1,`n']==1) & `clustervarnumber'>0 	{  
				capture qui ds(icc*)													  
				if _rc==0 {  
					if view_icc1[1,`n']==1  {											  
						local icctabletype `"$basicclustertable_icc1"'					  
						local icctablecaption `"$clustertable_caption_1"'				  
					}	    
					if view_icc2[1,`n']==1  {  
						local icctabletype `"$basicclustertable_icc2"'					  
						local icctablecaption `"$clustertable_caption_2"'				  
					}     
					      
					foreach cluster of local clustervars {								  
						local clpointer "$`cluster'"      		    					  
						local cl stcl`clpointer'										  
						local vt_number "vtnum_`clpointer'"  
						local clname_output "vt_$`vt_number'"  
						     
						if ("`cluster'"~="`centervars'" | view_icc1[1,`n']==1) & `=vp_levels_`strata'_`clpointer''>1  {	  
									  
							local varselect ""  
							foreach var of local `vt_`n''vars {  
								local varclusterlist ="`=key_observer_$$`var'' `=key_device_$$`var'' "		  
								if strpos("`varclusterlist'","`cluster' ")>0 {			  
									local varselect=strtrim("`varselect' `var'")  
								}  
							}   
				       
							if "`varselect'"~="" {  
								   
								local tablename "table_icc_`strata'_$`cluster'"				  
								if "``tablename'_tr'"=="" {									  
									local `tablename'_tr=1									  
									local ++tablepointer  
									local table`tablepointer'="`tablename'"					  
								}  
								   
								if view_icc1[1,`n']==1  local icc_header `"$clustertable_header_10 $`clname_output' `cluster'"'  
								if view_icc2[1,`n']==1  local icc_header `"$clustertable_header_10 $`clname_output' `cluster' (Level 2)  `centervars' (Level 3)"'  
								   
								dq_out_tab1   , varlist(`varselect')  tablename(`tablename')  tablerows(``tablename'_tr') memtable(1) gd(`gd') 		///  
									structure("`strata'") ststrata("`strata'") stcluster("$`cl'") cluster(`cluster') 								///  
									headertext("`icc_header'") subheadertext(".")																	///  
									captiontext("`icctablecaption'") displaymodified(1)																///  
									vartype(`n')  `icctabletype'  
									  
								local `tablename'_tr = `r(tablerows)'						  
							} 				  
						}    
					      
					}	    
				}      
			}       
		//outer standard loop	  
		}	       
	}	        
	if `tablepointer'>0		{													  
		forvalues n=1/`tablepointer' {  
		}	       
	}	        
}          
if  "`reportformat'"~="noreport"	 {  
	if am_colsum[1,1]>3 & `resultreport'==0 {  
		dq_out_cnt1, view_interpretation(`view_interpretation') view_dqi(`view_dqi') view_integrity(`view_integrity') view_changelog(`view_changelog') reportname(`reportname')  indent(`indent')  
	}         
	          
	if `benchmark'>0 {  
		$lineoutput paragraph	  
		$lineoutput text ("$resultreport_1"), font($textfont, $textsmall, $textcolor) 	  
		$lineoutput paragraph	  
		$lineoutput text ("$resultreport_3 `segmentname'"), font($textfont, $textsmall, $textcolor) 	  
		$lineoutput paragraph	  
		qui levelsof segmentname  
		$lineoutput text (r(levels)), font($textfont, $textsmall, $textcolor) 	  
		$lineoutput paragraph	  
		$lineoutput paragraph	  
		$lineoutput text ("$tableheader_dqi2"), bold font($textfont, $textsmall, $textcolor) 	  
	}         
	          
*graph pie, over(segment) graphregion(fcolor($framecolor) margin(large)) legend(position(left) cols(1) size(1))  plabel(_all percent, color(navy) size(1) format(%2.0f) gap(22))  
	          
	if `benchmark'==0 dq_out_des, casemissvars("`casemissvars'") itemmisslist("`itemmisslist'") itemjumplist("`itemjumplist'") idvars("`idvars'") /// 		  
													reportname(`reportname') reporttemplate(`reporttemplate') problemvarreport(`problemvarreport')  ///  
													metadatafile("`metadatafile'")   indent(`indent')  
	if (`view_integrity'~=0  & (`=integtablerows_studydata'>2 | `=integtablerows_metadata'>2)) |  `=integtablerows_commandcall'>2 |  `=integtablerows_analysisconduct'>2   {  
		$lineoutput paragraph	  
		$lineoutput text ("  ")	  
		$lineoutput paragraph	  
		$lineoutput text ("$tableheader_integrity_0")		, bold font($textfont, $header1, $textcolor)  
	}         
	if `resultreport'==0  {  
		if `view_integrity'~=0 {  
				if `=integtablerows_studydata'>2 | `=integtablerows_metadata'>2  {	  
					$lineoutput paragraph	  
					if `=integtablerows_studydata'<=2 &  `=integtablerows_metadata'>2  $lineoutput text ("$dataintegrity_issue_2")		, font($textfont, $textsmall, $textcolor)  
					if `=integtablerows_studydata'>2  &  `=integtablerows_metadata'<=2 $lineoutput text ("$dataintegrity_issue_1")		, font($textfont, $textsmall, $textcolor)  
					if `=integtablerows_studydata'>2  &  `=integtablerows_metadata'>2  $lineoutput text ("$dataintegrity_issue_3")		, font($textfont, $textsmall, $textcolor)  
				}      
			else {	  
				$lineoutput paragraph	  
				$lineoutput text ("$dataintegrity_issue_0")	, font($textfont, $textsmall, $textcolor)  
			}       
		}        
		if `=integtablerows_commandcall'>2  {  
			$lineoutput paragraph	  
			$lineoutput text ("$usererror_issue_1")				, font($textfont, $textsmall, $textcolor)  
		}        
		if `=integtablerows_analysisconduct'>2  {  
			$lineoutput paragraph	  
			$lineoutput text ("$DQ_IN_O3_IT1")					, font($textfont, $textsmall, $textcolor)  
		}        
		         
	}         
	if `resultreport'==0   $lineoutput pagebreak	  
				       
	if `view_interpretation' ~=0 & "`interpretationtextfile'"~="" {  
		dq_out_int,  indent(`indent') sdmd("`sdmd'") reportname("`reportname'") interpretationtextfile("`interpretationtextfile'")  
	}         
	local sectionbreak=0													  
	if `tablepointer'>0		{												  
		forvalues n=1/`tablepointer' {										  
			$lineoutput table frame`table`n'' = (1,1) , border(right, nil) border(left, nil) border(top, nil) border(bottom, nil)   border(insideV, nil)  	  
			$lineoutput table frame`table`n''(1,1) = table(`table`n'')		  
			        
			local sectionbreak=0											  
			if `sectionlinebreak'~=0  & ``table`n''_tr'> `linenumberpagebreak'  {  
				$lineoutput sectionbreak									  
				local sectionbreak=1  
			}       
		}	       
	}	        
	if 	`sectionbreak'==0 & `tablepointer'>0	  $lineoutput pagebreak	  
	local varrows=0																						  
	forvalues n=1/8 {																					  
		if view_variabledescriptive[1,`n']~=0 | view_timetrend[1,`n']~=0 | view_varsubgroup[1,`n']~=0  {  
			if "``vt_`n''vars'"~="" & ``vt_`n''varnumber'>0 {  
			        
				local vt = "vt_`n'e"																		  
				foreach var of local `vt_`n''vars {  
					local pointer "$`var'"         															  
					      
					capture confirm scalar key_datetime_$`pointer'  
					if _rc==0 {  
						local timeusevar "`=key_datetime_$`pointer''"  
					}     
						else local timeusevar "`timevars'"							  
					      
					if `tablepointer'>300 {  
					      
							    
						local tablepointer=0																  
						local ++reportcount																	  
						local reportnewname="`reportname'_part`reportcount'"								  
						if `view_integrity'~=0 & `=integtablerows_studydata'>2 & `reportcount'==1 {			  
							$lineoutput table table_integrityframebegin(1,1) = table(integtable_studydata)		  
						}    
						capture $lineoutput save "`srdd'\`reportnewname'_`reporttemplate'.`reportformat'", replace  
						local n=1  
						while _rc>0 & `n'<100 {			  
							capture $lineoutput save "`srdd'\`reportnewname'_`reporttemplate'_`n'.`reportformat'", replace  
							local ++n  
						}    
						     
						capture putpdf clear  
						$lineoutput begin, page(A4)  $pdfpageset1 												  
					}     
					      
					      
					if `=vp_levels_`strata'_`pointer''>1 {														  
						     
						local varrows=0																			  
						     
						if view_variabledescriptive[1,`n']~=0 | view_timetrend[1,`n']~=0  | view_varsubgroup[1,`n']~=0  {		  
					      
							$lineoutput paragraph  
							$lineoutput text ("$headertext_2 `var'")								, bold font($textfont, $header1, $textcolor)  
							$lineoutput paragraph  
							$lineoutput text ("$`vt': `=varlabel_`pointer'' ")						, font($textfont, $textsmall, $textcolor)  
							$lineoutput paragraph  
							$lineoutput text (`"$Datatype_1: `=data_type_$$`var'' / "')				, font($textfont, $textvsmall, $textcolor)  
							$lineoutput text (`"Stata-Format: `=data_change_format_$$`var'' / "')	, font($textfont, $textvsmall, $textcolor)  
							$lineoutput text (`"$Scale_level_1: `=scalelevel_$$`var''"')			, font($textfont, $textvsmall, $textcolor)  
							$lineoutput paragraph  
						}    
						if view_variabledescriptive[1,`n']~=0 {  
							dq_out_var1 , var(`var') strata(`strata') gd(`gd') vartype(`n') decimals(`decimals')   indent(`indent')	  
							local ++varrows  
							$lineoutput table deskript_table_`strata'_`pointer'(1,1) = table(sumtable_`strata'_`pointer')  
							$lineoutput paragraph	  
							$lineoutput paragraph	  
						}	   
					      
						if (view_timetrend[1,`n']~=0 | view_varsubgroup[1,`n']~=0) & `clustervarnumber'>0 & `n'<6	{		  
							local varclusterlist =strtrim("`=key_observer_$`pointer'' `=key_device_$`pointer''  ")		  
							foreach cluster of local clustervars {							  
							    
								if strpos("`varclusterlist'","`cluster'")>0 	 {			  
								   
									local clpointer "$`cluster'"      		    			  
									local cl stcl`clpointer'								  
									local vt_number "vtnum_`clpointer'" 					  
									local clname_output "vt_$`vt_number'" 					  
									  
									  
							    
									local tablename "table_lowvarsub_`strata'_`pointer'"	  
									if "``tablename'_tr'"=="" {								  
										local `tablename'_tr=1								  
										local ++tablepointer								  
										local table`tablepointer'="`tablename'"				  
									}  
									if `=vp_levels_`strata'_m`pointer'' ~= 2 {  
										local captiontextcontent `"$tablecaption_1 $changemiss (n=`=changemiss_`strata'_`pointer'') ; $changeextreme (n=`=changeextreme_`strata'_`pointer'')"'  
									}  
									if `=vp_levels_`strata'_m`pointer'' == 2 {  
											local captiontextcontent `"$tablecaption_1 $changemiss (n=`=changemiss_`strata'_`pointer'') ; $changebinaryrecode (n=`=changebinaryrecode_`strata'_`pointer'') ; $tablecaption_2 `=refcat_`strata'_`pointer''; "'  
											if strpos(`"`=refcat_`strata'_`pointer''"',"vs.")==0 {		  
											 	if `=refcat_`strata'_`pointer'' < `=vp_min_`strata'_`pointer'' 	local captiontextcontent `"`captiontextcontent' $tablecaption_2b"'  
											}  
									}  
									local table_type ""  
									if view_varsubgroup[1,`n']==1 local table_type "table_basic_margins"							  
									  
									if "`timeusevar'"~="" & view_timetrend[1,`n']==1 {  
											local captiontextcontent `"`captiontextcontent'  Variable for time trend: `timeusevar'"'  
											if view_varsubgroup[1,`n']==0 local table_type "table_basic_lowess"							  
											if view_varsubgroup[1,`n']==1 local table_type "table_basic_lowessmargins"					  
									}  
									  
									if "`tablename'"~="" {  
										  
										if `=vp_levels_`strata'_$`cluster''>$cluster_full_page {  
											$lineoutput pagebreak  
										}  
										  
										local ++varrows							  
										dq_out_tab1, varlist(`var')  tablename(`tablename')  tablerows(``tablename'_tr') memtable(0) gd(`gd') 								///  
											structure("`strata'") ststrata("`strata'") stcluster("$`cl'") cluster(`cluster') 												///  
											headertext("$Variable_1: `var'    $clustertable_header_10 $`clname_output' `cluster'") subheadertext(".")						///  
											captiontext("`captiontextcontent'")																								///  
											vartype(`n')  displaymodified(1) columnheader(0) varnameinfo(0) repeatheader(1) leavecaption(1) 		///  
											$`table_type'  
											  
										local `tablename'_tr = `r(tablerows)'					  
										  
										if strpos("`varclusterlist'","`cluster'")>0 & view_varcrosstab[1,`n']==1  {  
											  
											if `=vp_levels_`strata'_$`cluster''>$cluster_full_page {  
												$lineoutput pagebreak  
											}  
											  
											local ++varrows							  
											dq_out_tab1, varlist(`var')  tablename(`tablename')  tablerows(``tablename'_tr') memtable(0) gd(`gd') 							///  
												structure("`strata'") ststrata("`strata'") stcluster("$`cl'") cluster(`cluster') 											///  
												headertext("$clustertable_header_10 $`clname_output' `cluster'") subheadertext(".")											///  
												captiontext("`captiontextcontent'")																							///  
												vartype(`n')  displaymodified(0) columnheader(0) varnameinfo(0) repeatheader(1) leavecaption(1) 		///  
												$table_basic_descgraph  
												  
											local `tablename'_tr = `r(tablerows)'					  
									}  
									}  
									  
									  
							    
								}  
							    
							}	  
					      
						}    
			        
			        
						if view_timetrend[1,`n']~=0 & "`varclusterlist'"=="" 	{  
						     
								local tablename "table_singleline_`strata'_`pointer'"				  
								if "``tablename'_tr'"=="" {								  
									local `tablename'_tr=1								  
									local tablepointer=`tablepointer'+1					  
									local table`tablepointer'="`tablename'"				  
								}  
								   
								if "`timeusevar'"~="" {  
									local captiontextcontent `"Time Trend Graph $changemiss (n=`=changemiss_`strata'_`pointer'') ; $changeextreme (n=`=changeextreme_`strata'_`pointer''). Variable for time trend: `timeusevar'"'	  
								}  
						     
								local ++varrows							  
								dq_out_tab1, varlist(`var')  tablename(`tablename')  tablerows(``tablename'_tr') memtable(0) gd(`gd') 							///  
											structure("`strata'") ststrata("`strata'") stcluster("tt") cluster(tt) 												///  
											headertext("Time trend") subheadertext(".")																			///  
											captiontext("`captiontextcontent'")																					///  
											vartype(`n') displaymodified(1) columnheader(0) varnameinfo(0) repeatheader(1) leavecaption(1) 						///  
											columns(1) colcontent1("graph lowess")	 indent(`indent')															  
								local `tablename'_tr = `r(tablerows)'					  
							    
						}    
			        
			        
						if `varrows'>1  {  
							$lineoutput pagebreak			  
							local varrows=0  
						}    
				}      
			}       
			        
			}	      
		}	       
	}	        
		         
	if `sectionlinebreak'~=0 & `varrows'>0 $lineoutput pagebreak			  
		         
	*local append=0																  
	local tablerows=1				 											  
	forvalues n=1/8 {															  
		if `view_changelog'==1 {  
			if "``vt_`n''vars'"~="" & ``vt_`n''varnumber'>0 {  
				       
					dq_out_tab1   , varlist(``vt_`n''vars')  tablename(changelog) captiontext("$tablecaption_changelog1")  tablerows(`tablerows') ///  
									vartype(`n') structure("`strata'") or_vs_mod(2)	 $basictable_changelog1 	  
									  
					*local append=1													  
					local tablerows = `r(tablerows)'  
					      
				       
				       
			}	      
		}	       
	}	        
	if `tablerows'>1 $lineoutput pagebreak			  
	if `resultreport'==0 & `view_integrity'==1  {  
		local t_types metadata studydata commandcall analysisconduct  
		local n=1		  
		foreach t_t in `t_types' {  
			if `=integtablerows_`t_t''>2 {	  
				$lineoutput table table_integrityframe`n' = (1,1),  border(right, nil) border(left, nil) border(insideV, nil)  border(top, nil)  border(bottom, nil)  
				$lineoutput table table_integrityframe`n'(1,1) = table(integtable_`t_t')		  
				$lineoutput paragraph				  
				local ++n  
			}       
		}        
	}         
}          
if `reportcount'>0 return local reportname="`reportnewname'"			  
	else return local reportname="`reportname'"  
return local reportstop=0												  
window manage close graph  
end        
